////////////////////////////////////////////////
//
// 	AlkConn.java
//
package Alkindi.Services.Util;

import java.lang.*;
import java.sql.*;
import javax.sql.*;
import javax.naming.*;
import javax.rmi.*;
import Alkindi.Services.*;

/* 
$Header: AlkConn.java, 33, 4/27/01 3:41:59 PM, Schwartz, Joe$
$Log: 
 33   Alkindi Development1.32        4/27/01 3:41:59 PM   Schwartz, Joe   Added
      code to ignore error when setting Connection to autocommit; errors will
      occur when this code is executed within a transaction.
 32   Alkindi Development1.31        4/26/01 11:17:54 AM  Schwartz, Joe  
      Changed getConnection to throw AlkExcept instead of SQLException. Also, it
      now sets the returned connection to autocommit.
 31   Alkindi Development1.30        4/18/01 1:51:26 PM   Schwartz, Joe   Fixed
      name of column COL_AVGEVAL.
 30   Alkindi Development1.29        2/16/01 5:46:06 PM   Schwartz, Joe   Added
      UDT names to class.
 29   Alkindi Development1.28        2/5/01 3:07:50 PM    Schwartz, Joe   Sync
      with Rose.
 28   Alkindi Development1.27        2/5/01 12:37:13 PM   Schwartz, Joe  
      Changed constant names.
 27   Alkindi Development1.26        1/23/01 5:35:08 PM   Schwartz, Joe   Turned
      getConnection into a final static method. Put "jdbc/" prefix for
      connection pool into Rose model.
 26   Alkindi Development1.25        12/29/00 5:53:59 PM  Schwartz, Joe   Added
      the JNDI prefix for the database connection pool ("jdbc/").
 25   Alkindi Development1.24        12/28/00 1:07:25 PM  Schwartz, Joe   Added
      Version Control header info.
 24   Alkindi Development1.23        12/27/00 1:43:14 PM  Schwartz, Joe   
 23   Alkindi Development1.22        12/26/00 6:57:09 PM  Schwartz, Joe   
 22   Alkindi Development1.21        12/26/00 5:36:58 PM  Schwartz, Joe   
 21   Alkindi Development1.20        12/20/00 5:44:43 PM  Schwartz, Joe   
 20   Alkindi Development1.19        12/19/00 5:42:02 PM  Schwartz, Joe   
 19   Alkindi Development1.18        12/18/00 4:35:37 PM  Schwartz, Joe   
 18   Alkindi Development1.17        12/5/00 1:23:21 PM   Schwartz, Joe   Added
      null pointer protection in getConnection().
 17   Alkindi Development1.16        12/1/00 1:16:18 PM   Schwartz, Joe   
 16   Alkindi Development1.15        12/1/00 12:23:13 PM  Schwartz, Joe  
      Changed JNDI name of data source to match Orion server.
 15   Alkindi Development1.14        11/28/00 5:51:09 PM  Schwartz, Joe   
 14   Alkindi Development1.13        11/27/00 7:40:04 PM  Schwartz, Joe  
      Removed dependency on JNDI properties from Alkindi-MW.properties. Now uses
      default JNDI settings (which are set for EJB server in jndi.properties
      file)
 13   Alkindi Development1.12        11/27/00 7:29:00 PM  Schwartz, Joe  
      Removed dependency on jndi properties in Alkindi-MW.properties.
 12   Alkindi Development1.11        11/21/00 4:17:46 PM  Schwartz, Joe   
 11   Alkindi Development1.10        11/20/00 10:52:33 PM Schwartz, Joe   
 10   Alkindi Development1.9         11/14/00 12:53:12 PM Schwartz, Joe   
 9    Alkindi Development1.8         11/9/00 6:41:06 PM   Schwartz, Joe   
 8    Alkindi Development1.7         11/8/00 7:47:46 PM   Schwartz, Joe   
 7    Alkindi Development1.6         11/8/00 2:59:02 PM   Schwartz, Joe   
 6    Alkindi Development1.5         11/7/00 2:04:29 PM   Schwartz, Joe  
      Modified to use pooled JDBC connections provided by JDBC server.
 5    Alkindi Development1.4         10/22/00 10:38:39 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 4    Alkindi Development1.3         10/22/00 10:34:07 AM Schwartz, Joe   
 3    Alkindi Development1.2         10/17/00 2:22:47 PM  Schwartz, Joe  
      Delivery 10.16.00
 2    Alkindi Development1.1         10/7/00 4:34:29 PM   Schwartz, Joe   
 1    Alkindi Development1.0         10/7/00 4:29:08 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 */
public class AlkConn 
{
	public static final String COL_AVGEVAL = "AVG_PROD_RATING_BY_UC";
	public static final String COL_BBI = "bbi";
	public static final String COL_BI = "bi";
	public static final String COL_EAVE = "eave";
	public static final String COL_EI = "ei";
	public static final String COL_EPI = "epi";
	public static final String COL_EVALSCALEID = "EVALUATION_SCALE_ID";
	public static final String COL_FI = "fi";
	public static final String COL_MI = "mi";
	public static final String COL_NI = "ni";
	public static final String COL_PCID = "PRODUCT_CLUSTER_ID";
	public static final String COL_PID = "PRODUCT_ID";
	public final String COL_PTID = "PRODUCT_TYPE_ID";
	public static final String COL_RAVE = "rave";
	public static final String COL_RI = "ri";
	public static final String COL_UCID = "USER_CLUSTER_ID";
	public static final String COL_UCIDX = "USER_CLUSTER_INDEX";
	public static final String COL_UID = "USER_ID";
	public static final String DATASOURCE_JNDI_NAME = "java:comp/env/jdbc/Alkindi.DB.1";
	
	/**
	 * The SQL type name for a database object.
	 */
	public static final String OBJ_EVALSTAT = "ALKINDI_EVALSSTAT_T";
	
	/**
	 * The SQL type name for a database object.
	 */
	public static final String OBJ_PCRECSTAT = "ALKINDI.PCRECSTAT_T";
	public static final String OBJ_PRODRECSTAT = "ALKINDI.PRODRECSTAT_T";
	
	private AlkConn() 
	{
	}
	
	/**
	 * Retrieves a database Connection from the pool. <br>
	 * <b>Note:</b>&nbsp; The Connection is set to auto-commit.
	 * @return Connection
	 * @roseuid 3A7ED709034B
	 */
	public static final java.sql.Connection getConnection() throws AlkExcept 
	{ 
		try {
			//	Get initial JNDI naming context
			//
			Context initCtx = new InitialContext();
			//LogManager.dbgLog("AlkConn", "getConnection", "DATABASE_JNDI_NAME=" + dbName);
			//	Perform JNDI lookup on data source name
			//
			Object obj = initCtx.lookup(DATASOURCE_JNDI_NAME); 
			//	Narrow (safely cast)the found object to a data source 
			//
			DataSource dbSource = (DataSource)PortableRemoteObject.narrow(obj, DataSource.class); 
			//	Get a conneciton from the data source
			//
			Connection conn = dbSource.getConnection();
			//	Free resources 
			//
			initCtx.close();
			obj = null;
			//	Set connection to auto-commit. Calling setAutoCommit() when in a transaction
			//	throws an exception, so ignore them here.
			//
			try {
				conn.setAutoCommit(true);
			}
			catch (Exception e) {
			}
			
			if (conn == null) {
				throw new Exception("No database connection.");
			}
			return conn; 
		} 
		//	Handle exceptions by throwing them as SQLExceptions since 
		//	DB code already handles SQLExceptions.
		//	TODO: Change these to AlkExcept
		//
		catch(Exception E) {
			throw new AlkExcept(E.toString(), 6050);
		}
	}
}
